/*-----------------------------------------------------------------------------
 * sdq.c
 * EV2400 firmware
 * 
 * Jennie Kam
 * Version 0.5
 * Last updated: 5/28/09
 * 
 * Peripherials used:
 * 
 * Timer 1, A, CCR1 (port 1), CCR2 (port 2), from 1MHz ACLK, no divider
 * Timer 1, A, CCR0 (timeout), from 1MHz ACLK, no divider
 * Timer 0, B, CCR3 (pulse output), from 1MHz ACLK, no divider 
 * ---------------------------------------------------------------------------*/
 
#include "sdq.h"
#include "sw.h"

 /*----------------------------------------------------------------------------+
| Essential SDQ functions
+----------------------------------------------------------------------------*/

void SDQBitWrite(unsigned char data)
{
  P1DIR |= P1_SDQ;                          // TA.1 or TA.2 as output
  //TACTL = TASSEL_2 + MC_2;                  // SMCLK, continuous mode
  TACCTL1 = OUTMOD_0 + OUT;                 // TACCTL OUT bit controls output
  ISRMode = imSDQwrite;
  if(data & 0x01)
    TACCR1 = TAR + tSDQone;
  else
    TACCR1 = TAR + tSDQzero;      
  TACCTL1 = OUTMOD_0 + CCIE;
  while(write_done==0);
  write_done = 0;
}

void SDQByteWrite(unsigned char data)
{
  unsigned char j;
  for(j = 0; j < 8; j++)
  {
    SDQBitWrite((data>>j) & 0x01);
  }
}

unsigned char SDQBitRead(void)
{
  //  DON'T FORGET TO DISABLE INTERRUPTS IF YOU DON'T USE THE TIMER?
  P1OUT &= ~P1_SDQ;                        // output
  P1DIR |= P1_SDQ;                         // pull line low
  
  __delay_cycles(48);                       // 2us
  
  P1DIR &= ~P1_SDQ;                        // Input

  __delay_cycles(72);                       // 3us before checking data line
  
  if(TACCTL1 & CCI)
    return 1;
  else
    return 0;
}

unsigned char SDQByteRead(void)
{
  unsigned char m, byte, bit;
  byte = 0;
  for(m = 0; m < 8; m++)
  {
    bit = SDQBitRead();
    byte = byte + (bit << m);
  }
  return byte;
}

void SDQresetpulse(void)
{
  P1DIR |= P1_SDQ;                          // TA.1 as output
  TACCTL1 = OUTMOD_0 + OUT;                 // TACCTL OUT bit controls output
  ISRMode = imSDQpulse;     
  TACCR1 = TAR + tSDQreset;                 // Add reset time (480us) to TAR
  while(pulse_done==0);                     // Wait for finish 
  pulse_done = 0;                           // Done w/ pulse detection
  P1DIR |= P1_SDQ;                          // Back to output; pulse detection flipped it to input
}

